document.addEventListener('DOMContentLoaded', () => {
    const draggables = document.querySelectorAll('.draggable-animal');
    const categories = document.querySelectorAll('.animal-drop-zone');

    draggables.forEach(animal => {
        animal.addEventListener('dragstart', dragStart);
    });

    categories.forEach(zone => {
        zone.addEventListener('dragover', dragOver);
        zone.addEventListener('drop', dropAnimal);
    });

    document.getElementById('check-btn').addEventListener('click', checkAnswers);
    document.getElementById('restart-btn').addEventListener('click', resetGame);
});

function dragStart(event) {
    event.dataTransfer.setData('text', event.target.id);
}

function dragOver(event) {
    event.preventDefault();
}

function dropAnimal(event) {
    event.preventDefault();
    const animalId = event.dataTransfer.getData('text');
    const animal = document.getElementById(animalId);

    // Clonar la imagen arrastrada
    const newAnimal = animal.cloneNode(true); // Clonar la imagen
    newAnimal.style.width = '50px'; // Ajustar el tamaño según sea necesario
    newAnimal.style.height = 'auto';

    // Añadir la nueva imagen a la zona de la categoría
    event.target.appendChild(newAnimal);

    // Evitar que se oculten imágenes originales
    // En lugar de ocultar, simplemente podemos mantenerla visible
}

function checkAnswers() {
    const correctCategories = {
        mammals: ['dog', 'cat'],
        birds: ['bird', 'parrot'],
        reptiles: ['snake', 'turtle']
    };

    let allCorrect = true;

    for (const category in correctCategories) {
        const animalsInCategory = [...document.getElementById(category).querySelectorAll('img')].map(animal => animal.id);
        const expectedAnimals = correctCategories[category];

        // Verifica si los IDs de los animales en la categoría son los correctos
        if (!expectedAnimals.every(animal => animalsInCategory.includes(animal)) || expectedAnimals.length !== animalsInCategory.length) {
            allCorrect = false;
            break;
        }
    }

    if (allCorrect) {
        document.getElementById('result-message').textContent = '¡Correcto!';
    } else {
        document.getElementById('result-message').textContent = 'Algunos animales están en la categoría incorrecta. Inténtalo de nuevo.';
    }

    document.getElementById('restart-btn').classList.remove('hidden'); // Mostrar botón de reinicio
}

function resetGame() {
    const categories = document.querySelectorAll('.animal-drop-zone');
    categories.forEach(zone => {
        zone.innerHTML = ''; // Limpiar las categorías
    });

    const animalBank = document.querySelector('.animal-bank');

    // Restablecer las imágenes arrastrables
    animalBank.innerHTML = `
        <img src="imganimales/a1.png" alt="Perro" class="draggable-animal" draggable="true" id="dog">
        <img src="imganimales/a2.png" alt="Gato" class="draggable-animal" draggable="true" id="cat">
        <img src="imganimales/a3.png" alt="Pájaro" class="draggable-animal" draggable="true" id="bird">
        <img src="imganimales/a4.png" alt="Serpiente" class="draggable-animal" draggable="true" id="snake">
        <img src="imganimales/a5.png" alt="Tortuga" class="draggable-animal" draggable="true" id="turtle">
        <img src="imganimales/a6.png" alt="Loro" class="draggable-animal" draggable="true" id="parrot">
    `;

    // Asegurarse de que las imágenes sean arrastrables nuevamente
    const newDraggables = document.querySelectorAll('.draggable-animal');
    newDraggables.forEach(animal => {
        animal.addEventListener('dragstart', dragStart);
    });

    // Restablecer el mensaje
    document.getElementById('result-message').textContent = '';
    document.getElementById('restart-btn').classList.add('hidden'); // Ocultar el botón de reinicio

    // Volver a mostrar las imágenes originales en el banco de animales
    const allAnimals = document.querySelectorAll('.draggable-animal');
    allAnimals.forEach(animal => {
        animal.style.display = 'inline'; // Mostrar de nuevo las imágenes originales
    });
}









